libname q 'C:\SASCodeForBook\SASDataSets';
Data adlten5; set q.tenadl01t05;  

/*this code replicates Data of Table 8.11*/

Remembrance = 1 - TooMuchShoahTalk; 

Valueslife = (PAProPeace + IsraelProPeace + remembrance)/3;
ValuesJewishLife = (IsraelProPeace + remembrance)/2;
propeace = (PAProPeace + IsraelProPeace)/2;

DislikesIsrael = (IsraelAntiPeace + ViewsIsraelUnfavorably)/2;

cohesion = (ownkind + loyaltoIsrael)/2;
corruption = (shady + toomuchpower)/2;
 
RadicalRight = 0;
If country = 'Belgium' then RadicalRight = 1;
If country = 'Austria' then RadicalRight = 1;
If country = 'France' then RadicalRight = 1;
count = 500;

Reparations = 0;
If country = 'Germany' then Reparations = 1;
If country = 'Austria' then Reparations = 1;
If country = 'Switzerland' then Reparations = 1;
 
AntiPeace = (PAAntiPeace + IsraelAntiPeace)/2;

Belgium = 0;
If country = 'Belgium' then Belgium = 1;

ManyJewsMuslims = 0;
if (jewishbinary = 1 and muslimbinary = 1) then manyjewsmuslims = 1;

Twotreatments = ManyJewsMuslims;

Threetreatments = 0;
If (jewishbinary = 0 and muslimbinary = 0) then threetreatments = 3;
If (jewishbinary = 0 and muslimbinary = 1) then threetreatments = 2;
If (jewishbinary = 1 and muslimbinary = 1) then threetreatments = 1;

Yeardummy = 0;
If year = 2004 then yeardummy = 1;

Fiveyears = 0;
If year = 2001 then Fiveyears = 5;
If year = 2002 then Fiveyears = 4;
If year = 2003 then Fiveyears = 3;
If year = 2004 then Fiveyears = 2;
If year = 2005 then Fiveyears = 1;

Disaffection = (IsraelAntiPeace + PAProPeace + ViewsIsraelUnfavorably + ProPalestine)/4;

fiveitems =(toomuchshoahtalk + ownkind + loyaltoIsrael + shady + toomuchpower)/5;

run;

Title1 'Table 8.11 This run applies poisson regression random intercepts only Model 1';
proc glimmix data = ADLTen5 method=rspl ic=q ;
	class  country threetreatments;
	model Newvio5 =  / dist = poisson link =log s;
	random country(threetreatments) /s ;
	random _residual_ /s;
	covtest 'zerog = no G-side' zerog /cl Wald estimates;
run;


Title1 'This run applies poisson regression Model 5, Palestinians are Pro Peace';
proc glimmix data = ADLTen5 method = rspl ic=q;
	class  country fiveyears threetreatments Belgium;
	model Newvio5 = fiveyears|threetreatments Belgium PAProPeace  / dist = poisson link =log s;
	random country(threetreatments) /s ;
	random _residual_ /s;
	covtest 'zerog = no G-side' zerog /cl Wald estimates;
run;


Title1 'This run applies poisson regression Model 8, Values Jewish Lives';
proc glimmix data = ADLTen5 method = rspl ic=q;
	class  country fiveyears threetreatments Belgium;
	model Newvio5 = fiveyears|threetreatments Belgium ValuesJewishLife  / dist = poisson link =log s;
	random country(threetreatments) /s ;
	random _residual_ /s;
	covtest 'zerog = no G-side' zerog /cl Wald estimates;
run;

Title1 'This run applies poisson regression Model 9 Ambivalence, Values Jewish and Palestinian Lives';
proc glimmix data = ADLTen5 method = rspl ic=q;
	class  country fiveyears threetreatments Belgium;
	model Newvio5 = fiveyears|threetreatments Belgium ValuesLife  / dist = poisson link =log s;
	random country(threetreatments) /s ;
	random _residual_ /s;
	covtest 'zerog = no G-side' zerog /cl Wald estimates;
run;

/*Data for footnotes*/

Title1 'This run applies poisson regression model, dislikesIsrael test factor';
proc glimmix data = ADLTen5 method = rspl ic=q;
	class  country fiveyears threetreatments Belgium;
	model Newvio5 = fiveyears|threetreatments Belgium dislikesIsrael/
		dist = poisson link =log s;
	random country(threetreatments) /s ;
	random _residual_ /s;
covtest 'zerog = no G-side' zerog /cl Wald estimates;
run;

Title1 'This run applies poisson regression model, Antisemitism test factor';
proc glimmix data = ADLTen5 method = rspl ic=q;
	class  country fiveyears threetreatments Belgium;
	model Newvio5 = fiveyears|threetreatments Belgium fiveitems/ 
		dist = poisson link =log s;
	random country(threetreatments) /s ;
	random _residual_ /s;
	covtest 'zerog = no G-side' zerog /cl Wald estimates;
run;

/*These runs provide estimates of the Deviance and Scaled Deviance, the BIC is same if ic=q
rather than ic=pq is used in the Glimmix runs.The Macro must be available for these runs 
to be implemented*/

 /*This calls the GLMM Macro the source will not be printed*/
%inc 'c:\Program Files\glmm800.sas'/nosource;
run;
%glimmix (data = ADLTen5, procopt=method=reml covtest ratio ic , maxit =100, 
stmts=%str(Title1 'This run applies poisson regression five time 
periods three treatments Baseline Model 1';
class fiveyears country threetreatments Belgium;
model Newvio5 = / s;
random country(threetreatments) /s ;
			),
error = poisson,
link = log);
run;

 /*This calls the GLMM Macro the source will not be printed*/
%inc 'c:\Program Files\glmm800.sas'/nosource;
run;
%glimmix (data = ADLTen5, procopt=method=reml covtest ratio ic , maxit =100, out=Bob5,
stmts=%str(Title1 'This run applies poisson regression five time 
periods three treatments PAProPeace and Belgium Model 5';
class fiveyears country threetreatments Belgium;
model Newvio5 = fiveyears|threetreatments Belgium PAProPeace  / s;
random country(threetreatments) /s ;
	lsmeans fiveyears /cl;
	lsmeans threetreatments/cl;
	lsmeans fiveyears*threetreatments /cl;
	lsmeans Belgium/cl;
		),
error = poisson,
link = log);
run;
data bob51; set BOB5; 
Proc sort; by threetreatments country;
proc print; run;




data adlten5; set adlten5;
 /*This calls the GLMM Macro the source will not be printed*/
%inc 'c:\Program Files\glmm800.sas'/nosource;
run;
%glimmix (data = ADLTen5, procopt=method=reml covtest ratio ic , out=Bob8,
stmts=%str(Title1 'This run applies poisson regression five time 
periods three treatments ValuesJewishLife and Belgium  Model 8 ';
class fiveyears country threetreatments Belgium ;
model Newvio5 = fiveyears | threetreatments belgium valuesjewishLife / s;
random country(threetreatments) /s ;
	lsmeans fiveyears /cl;
	lsmeans threetreatments/cl;
	lsmeans Belgium/cl;
	
	),
error = poisson,
link = log);
run;

data bob81; set BOB8; 
Proc sort; by threetreatments country;
proc print; run;





data adlten5; set adlten5;
 /*This calls the GLMM Macro the source will not be printed*/
%inc 'c:\Program Files\glmm800.sas'/nosource;
run;
%glimmix (data = ADLTen5, procopt=method=reml covtest ratio ic , out=Bob9,
stmts=%str(Title1 'This run applies poisson regression five time 
periods three treatments ValuesLife and Belgium  Model 9 ';
class fiveyears country threetreatments Belgium ;
model Newvio5 = fiveyears | threetreatments belgium valuesLife / s;
random country(threetreatments) /s ;
	lsmeans fiveyears /cl;
	lsmeans threetreatments/cl;
	lsmeans Belgium/cl;
		),
error = poisson,
link = log);
run;

data bob91; set BOB9; 
Proc sort; by threetreatments country;
proc print; run;

	/*The code for Table 8.9 is now complete*/
	/*The syntax in this file is copyright by Robert B. Smith,  2011. */
